
IF NOT EXISTS (SELECT * FROM GLB_PROCD_OUTR WHERE CD_OUTR_PROCD = 104 )
BEGIN
    INSERT INTO GLB_PROCD_OUTR (CD_OUTR_PROCD,DS_OUTR_PROCD) VALUES (104,'DATASYNC - SINCRONIZAÇÃO')
END
;
IF NOT EXISTS (SELECT * FROM GLB_PROCD_OUTR WHERE CD_OUTR_PROCD = 105 )
BEGIN
    INSERT INTO GLB_PROCD_OUTR (CD_OUTR_PROCD,DS_OUTR_PROCD) VALUES (105,'DATASYNC - CONFIGURAÇÃO')
END
;
IF NOT EXISTS (SELECT * FROM GLB_PROCD_OUTR WHERE CD_OUTR_PROCD = 106 )
BEGIN
    INSERT INTO GLB_PROCD_OUTR (CD_OUTR_PROCD,DS_OUTR_PROCD) VALUES (106,'DATASYNC - CONFERE MOVIMENTO')
END



IF OBJECT_ID('UDF_DSYNC_AUTHORIZATION') IS NOT NULL 
	DROP FUNCTION UDF_DSYNC_AUTHORIZATION 
GO 

CREATE FUNCTION UDF_DSYNC_AUTHORIZATION(@CD_USU INT)
RETURNS TABLE
AS RETURN
SELECT	DISTINCT
        USUARIO.CD_USU AS USERNAME,
        CASE AUTORIZACAO.CD_PROCD
        WHEN 104 THEN 'ROLE_DATASYNC'
        WHEN 105 THEN 'ROLE_CONFIG'
        WHEN 106 THEN 'ROLE_CONF_MOV'
        ELSE
                CASE GRUPO.TD_PRIV WHEN 1 THEN 'ROLE_ADMIN'
                ELSE
                        'ROLE_USER'
                END
        END AS AUTHORITY
FROM	GLB_USU USUARIO
        INNER JOIN GLB_USU_GRP GRUPOS ON
                USUARIO.CD_USU = GRUPOS.CD_USU
        INNER JOIN GLB_GRP_USU GRUPO ON
                GRUPOS.CD_GRP = GRUPO.CD_GRP
        LEFT JOIN GLB_GRP_USU_AUTR AUTORIZACAO ON
                AUTORIZACAO.CD_GRP = GRUPO.CD_GRP
WHERE	USUARIO.CD_USU = @CD_USU

GO


IF OBJECT_ID('UDF_DSYNC_AUTHENTICATION') IS NOT NULL 
	DROP FUNCTION UDF_DSYNC_AUTHENTICATION 
GO 

	CREATE FUNCTION UDF_DSYNC_AUTHENTICATION(@CD_USU INT)
	RETURNS TABLE
	AS RETURN
        SELECT	CD_USU AS USERNAME,SENHA AS PASSWORD,CASE SIT WHEN 0 THEN 1 ELSE 0 END AS ENABLE
        FROM	GLB_USU
        WHERE	CD_USU = @CD_USU